import sys
import os
import shutil

# Color mapping
color_map = {
    "0": "lime", "1": "white", "2": "lightgray", "3": "gray",
    "4": "black", "5": "brown", "6": "red", "7": "orange",
    "8": "yellow", "9": "green", "10": "cyan", "11": "lightblue",
    "12": "blue", "13": "purple", "14": "magenta", "15": "pink"
}

def rename_image(file_path):
    directory, filename = os.path.split(file_path)
    name, ext = os.path.splitext(filename)
    
    if "_" not in name:
        print(f"Skipping '{filename}': Filename format not recognized. Expected format: 'X_0.png'")
        return
    
    base_name = name.rsplit("_", 1)[0]
    
    for key in color_map:
        if name.endswith(f"_{key}"):
            new_name = base_name + f"_{color_map[key]}{ext}"
            new_path = os.path.join(directory, new_name)
            os.rename(file_path, new_path)
            print(f"Renamed '{filename}' to '{new_name}'")
            
            # Create extra textures for main, secondary, and glow items
            if "main" in base_name.lower():
                default_name = base_name + f"_default{ext}"
                default_path = os.path.join(directory, default_name)
                
                # Find if there's a black texture (color_map key "4")
                black_name = base_name + f"_{color_map['4']}{ext}"
                black_path = os.path.join(directory, black_name)
                
                if os.path.exists(black_path):
                    shutil.copy2(black_path, default_path)
                    print(f"Created default texture (black) for main item: '{default_name}'")
                else:
                    print(f"Warning: Could not find black texture to copy as default for '{base_name}'")
                
            elif "secondary" in base_name.lower():
                default_name = base_name + f"_default{ext}"
                default_path = os.path.join(directory, default_name)
                
                # Find if there's a white texture (color_map key "1")
                white_name = base_name + f"_{color_map['1']}{ext}"
                white_path = os.path.join(directory, white_name)
                
                if os.path.exists(white_path):
                    shutil.copy2(white_path, default_path)
                    print(f"Created default texture (white) for secondary item: '{default_name}'")
                else:
                    print(f"Warning: Could not find white texture to copy as default for '{base_name}'")
            
            elif "_glow" in base_name.lower():
                default_name = base_name + f"_default{ext}"
                default_path = os.path.join(directory, default_name)
                
                # Find if there's a lime texture (color_map key "0")
                lime_name = base_name + f"_{color_map['0']}{ext}"
                lime_path = os.path.join(directory, lime_name)
                
                if os.path.exists(lime_path):
                    shutil.copy2(lime_path, default_path)
                    print(f"Created default texture (lime) for glow item: '{default_name}'")
                else:
                    print(f"Warning: Could not find lime texture to copy as default for '{base_name}'")
            
            return
    
    print(f"Skipping '{filename}': No matching color index found in filename.")

if __name__ == "__main__":
    if len(sys.argv) > 1:
        # Process all files first to ensure all color variants exist before creating defaults
        for file_path in sys.argv[1:]:
            file_path = file_path.strip('"')  # Handle spaces in file path
            rename_image(file_path)
    else:
        print("Drag and drop one or more images onto this script to rename them.")
